using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents simple VistALink protocol request 
	/// messages as defined in vlSimpleRequest.xsd
	/// </summary>
	public abstract class VistALinkSimpleRequestMessage : BaseRequestMessage
	{
		/// <summary>
		/// Message type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string MessageType = "gov.va.med.foundations.vistalink.system.request";

		/// <summary>
		/// Message XSD schema filenamespace  string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string XsdName = "vlSimpleRequest.xsd";

		/// <summary>
		/// Constructor allowing to create VistALink simple request message from its type.  
		/// </summary>
		/// <param name="requestType">Message request type</param>
		protected VistALinkSimpleRequestMessage( string requestType ) 
			: base( MessageType, XsdName, requestType ){}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="requestType">VistALink simple request message type.</param>
		/// <param name="sourceDoc">Source XML document.</param>
		protected VistALinkSimpleRequestMessage( string requestType, XmlDocument sourceDoc )
			: base( MessageType, XsdName, requestType, sourceDoc ){}
	}
}
